/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.connector.utility;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class ConnectorPreferences {
    private static Preferences m_prefs = null;
    private static final String NODENAME = "/org/hyperimage/connector/fedora3";
    private static final String PREF_FILENAME = "hif3connprefs.xml";
    private static URL m_PrefURL = null;
    private static final String FEDORA_URL_KEY = "fedoraURL";
    private static final String DEF_FEDORA_URL = "http://hyperimage.cms.hu-berlin.de:8080/fedora/wsdl?api=API-A";

    public ConnectorPreferences() {
        m_prefs = Preferences.userRoot().node(NODENAME);
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        m_PrefURL = classloader.getResource("./conf/hif3connprefs.xml");
        this.loadPrefs();
    }

    public String getFedoraURLPref() {
        return m_prefs.get(FEDORA_URL_KEY, DEF_FEDORA_URL);
    }

    private void loadPrefs() {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(m_PrefURL.getFile()));
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        try {
            Preferences.importPreferences(is);
        }
        catch (InvalidPreferencesFormatException ipfe) {
            ipfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

