/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.connector.utility;

import com.sun.media.jai.codec.SeekableStream;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.SubsampleAverageDescriptor;

public class ImageHelper {
    public static PlanarImage convertByteArrayToPlanarImage(byte[] data) {
        if (data == null) {
            return null;
        }
        return JAI.create("stream", SeekableStream.wrapInputStream(new ByteArrayInputStream(data), true));
    }

    public static PlanarImage scaleImageTo(PlanarImage originalImage, Dimension scaleDimension) {
        PlanarImage thumbnailImage;
        if (originalImage == null) {
            return null;
        }
        Double scaleX = (double)originalImage.getWidth() / new Double(scaleDimension.width);
        Double scaleY = (double)originalImage.getHeight() / new Double(scaleDimension.height);
        Double scale = 1.0 / Math.max(scaleX, scaleY);
        if (scaleX > 1.0 || scaleY > 1.0) {
            PlanarImage ren = originalImage;
            thumbnailImage = SubsampleAverageDescriptor.create(ren, scale, scale, null).getRendering();
        } else {
            thumbnailImage = originalImage;
        }
        return thumbnailImage;
    }
}

