/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.connector.yenda;

import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.message.GZipEncoder;

public class YLProjectClientREST {
    private WebTarget webTarget;
    private Client client;
    private String BASE_URI;
    private String username = "";
    private String password = "";

    public YLProjectClientREST(String URI2) {
        this.BASE_URI = URI2;
        this.client = ClientBuilder.newBuilder().sslContext(this.getSSLContext()).build();
        this.client.register(HttpAuthenticationFeature.basicBuilder().nonPreemptive().build());
        this.webTarget = this.client.target(this.BASE_URI).path("v1");
        this.webTarget.register(GZipEncoder.class);
    }

    public YLProjectClientREST(String URI2, String username, String password) {
        this(URI2);
        this.setUsernamePassword(username, password);
    }

    public <T> T findProjects(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("projects");
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T find(Class<T> responseType, String id) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path(MessageFormat.format("project/{0}", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findPreferences(Class<T> responseType, String id) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path(MessageFormat.format("project/{0}/preferences", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findPreferences(GenericType<T> responseType, String id) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path(MessageFormat.format("project/{0}/preferences", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findTemplates(Class<T> responseType, String id) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path(MessageFormat.format("project/{0}/templates", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findTemplates(GenericType<T> responseType, String id) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path(MessageFormat.format("project/{0}/templates", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findUserProjects(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("projects/own");
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findUserProjects(GenericType<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("projects/own");
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findGroups(Class<T> responseType, String id, String type) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        if (type != null) {
            resource = resource.queryParam("type", type);
        }
        resource = resource.path(MessageFormat.format("project/{0}/groups", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T findGroups(GenericType<T> responseType, String id, String type) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        if (type != null) {
            resource = resource.queryParam("type", type);
        }
        resource = resource.path(MessageFormat.format("project/{0}/groups", id));
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public void close() {
        this.client.close();
    }

    public final void setUsernamePassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        };
    }

    private SSLContext getSSLContext() {
        X509TrustManager x509 = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{x509}, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }
}

