/*
 * Decompiled with CFR 0.152.
 */
package org.hyperimage.connector.yenda;

import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.message.GZipEncoder;

public class YendaClientREST {
    private WebTarget webTarget;
    private Client client;
    private static String BASE_URI;
    private String username = "";
    private String password = "";

    public YendaClientREST(String URI2) {
        BASE_URI = URI2;
        this.client = ClientBuilder.newBuilder().sslContext(this.getSSLContext()).build();
        this.client.register(HttpAuthenticationFeature.basicBuilder().nonPreemptive().build());
        this.webTarget = this.client.target(BASE_URI).path("legacy");
        this.webTarget.register(GZipEncoder.class);
    }

    public YendaClientREST(String URI2, String username, String password) {
        this(URI2);
        this.setUsernamePassword(username, password);
    }

    public <T> T getVersion(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("getVersionID");
        return resource.request("text/plain").get(responseType);
    }

    public <T> T isAuthenticated(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("authenticate");
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T apiInfo(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        return resource.request("text/html").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public <T> T properties(Class<T> responseType) throws ClientErrorException {
        WebTarget resource = this.webTarget;
        resource = resource.path("properties");
        return resource.request("application/json").property("jersey.config.client.http.auth.basic.username", this.username).property("jersey.config.client.http.auth.basic.password", this.password).get(responseType);
    }

    public void close() {
        this.client.close();
    }

    public final void setUsernamePassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        };
    }

    private SSLContext getSSLContext() {
        X509TrustManager x509 = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("SSL");
            ctx.init(null, new TrustManager[]{x509}, null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return ctx;
    }
}

